/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.client.render.infobar.AreaDistanceElement;
import dev.toma.gunsrpg.client.render.infobar.QuestDisplayDataModel;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.quest.area.IAreaQuest;
import dev.toma.gunsrpg.common.quests.quest.area.IQuestAreaProvider;
import dev.toma.gunsrpg.common.quests.quest.area.QuestArea;
import dev.toma.gunsrpg.common.quests.trigger.ITriggerHandler;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.common.quests.trigger.TriggerResponseStatus;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractAreaBasedQuest<D extends IQuestData & IQuestAreaProvider>
extends Quest<D>
implements IAreaQuest {
    protected int gracePeriod;
    protected boolean areaEntered;
    protected QuestArea area;

    public AbstractAreaBasedQuest(QuestScheme<D> scheme, UUID traderId) {
        super(scheme, traderId);
        this.gracePeriod = this.getGracePeriodDuration();
    }

    public AbstractAreaBasedQuest(QuestDeserializationContext<D> context) {
        super(context);
    }

    @Override
    public QuestArea getQuestArea() {
        return this.area;
    }

    @Override
    public final void tickQuest(PlayerEntity player) {
        super.tickQuest(player);
        QuestStatus status = this.getStatus();
        if (status == QuestStatus.ACTIVE && this.area != null) {
            if (this.areaEntered) {
                this.area.tickArea(player.field_70170_p, player);
            } else {
                this.savePlayerStatusProperties(player);
            }
            if (this.area.isInArea((Entity)player)) {
                this.gracePeriod = this.getGracePeriodDuration();
            } else if (this.areaEntered) {
                --this.gracePeriod;
                if (!player.field_70170_p.field_72995_K) {
                    String time = Interval.format(this.gracePeriod, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.SECOND));
                    ((ServerPlayerEntity)player).func_241151_a_((ITextComponent)new TranslationTextComponent("quest.return_to_area", new Object[]{time}).func_240699_a_(TextFormatting.RED), ChatType.GAME_INFO, Util.field_240973_b_);
                }
            }
        }
        this.onQuestTick(player);
    }

    protected void onQuestTick(PlayerEntity player) {
    }

    @Override
    public final void registerTriggers(Quest.ITriggerRegistration registration) {
        this.registerDefaultTriggers(registration);
        this.registerAdditionalTriggers(registration);
    }

    protected void registerDefaultTriggers(Quest.ITriggerRegistration registration) {
        registration.addEntry(Trigger.TICK, this::onTick, this::handleSuccessfulTick);
        registration.addEntry(Trigger.PLAYER_DIED, this::onPlayerDeath, ITriggerHandler.NONE);
    }

    protected void registerAdditionalTriggers(Quest.ITriggerRegistration registration) {
    }

    protected abstract void handleSuccessfulTick(Trigger var1, IPropertyReader var2);

    protected TriggerResponseStatus onTick(Trigger trigger, IPropertyReader reader) {
        PlayerEntity player = reader.getProperty(QuestProperties.PLAYER);
        this.generateAreaIfMissing(player);
        if (this.area.isInArea((Entity)player)) {
            this.areaEntered = true;
            return TriggerResponseStatus.OK;
        }
        return this.areaEntered && !this.isGracePeriodActive() ? TriggerResponseStatus.FAIL : TriggerResponseStatus.PASS;
    }

    protected TriggerResponseStatus onPlayerDeath(Trigger trigger, IPropertyReader reader) {
        return this.areaEntered ? TriggerResponseStatus.FAIL : TriggerResponseStatus.PASS;
    }

    @Override
    protected boolean overrideFailureFromCondition() {
        return !this.areaEntered;
    }

    protected int getGracePeriodDuration() {
        return Interval.seconds(5).getTicks();
    }

    protected boolean isGracePeriodActive() {
        return this.gracePeriod > 0;
    }

    protected QuestArea generateArea(D activeData) {
        return ((IQuestAreaProvider)activeData).getAreaScheme().getArea(this.player.field_70170_p, (int)this.player.func_226277_ct_(), (int)this.player.func_226281_cx_());
    }

    protected void fillAreaDataModel(QuestDisplayDataModel dataModel) {
        if (this.area != null) {
            dataModel.addElement(new AreaDistanceElement<AbstractAreaBasedQuest>(this, QuestArea.STAY_IN_AREA, this::fillAreaInfo, quest -> quest.area != null ? quest.area.getCenter() : BlockPos.field_177992_a));
        }
    }

    protected ITextComponent fillAreaInfo(AbstractAreaBasedQuest<D> quest) {
        boolean tooClose;
        PlayerEntity player = quest.player;
        QuestArea area = quest.area;
        double distance = area.getDistance((Entity)player);
        int intDist = (int)distance;
        String text = intDist + "m";
        int size = area.getScheme().getSize();
        boolean bl = tooClose = size - intDist < 8;
        TextFormatting color = area.isInArea((Entity)player) ? (tooClose ? TextFormatting.YELLOW : TextFormatting.GREEN) : TextFormatting.RED;
        return new TranslationTextComponent(text).func_240699_a_(color);
    }

    @Override
    protected final void writeQuestData(CompoundNBT nbt) {
        nbt.func_74768_a("gracePeriod", this.gracePeriod);
        nbt.func_74757_a("areaEntered", this.areaEntered);
        if (this.area != null) {
            nbt.func_218657_a("area", (INBT)this.area.toNbt());
        }
        this.writeAdditionalData(nbt);
    }

    @Override
    protected final void readQuestData(CompoundNBT nbt) {
        this.gracePeriod = nbt.func_74762_e("gracePeriod");
        this.areaEntered = nbt.func_74767_n("areaEntered");
        if (nbt.func_150297_b("area", 10)) {
            Object data = this.getActiveData();
            this.area = QuestArea.fromNbt(((IQuestAreaProvider)data).getAreaScheme(), nbt.func_74775_l("area"));
        }
        this.readAddtionalData(nbt);
    }

    protected void writeAdditionalData(CompoundNBT nbt) {
    }

    protected void readAddtionalData(CompoundNBT nbt) {
    }

    private void generateAreaIfMissing(PlayerEntity player) {
        if (this.area != null) {
            return;
        }
        Object activeData = this.getActiveData();
        this.area = this.generateArea(activeData);
        this.trySyncClient();
    }
}

